<%@page language="java" buffer="64kb" errorPage="/Error.jsp"%>
<%@include file="Common.inc"%>
<%!
//	Local variable declarations. Note rating list is used 
//	by RateMovies includes.
//
RatingList ratingList;
SystemUser user;
String errMsg;
String email, pwd;
boolean showIndexPage = true;
%>

<%
//	Logout current user if any
//
logoutUser(session);
//	Assume we must show the index page
//
showIndexPage = true;

//	Check if someone is trying to log on
//
errMsg = "";
email = request.getParameter("email");
pwd = request.getParameter("pwd");

//	If logon parameters were submitted, validate them
//
if (email != null) {
	email = email.toLowerCase();
	// 	Check email format.
	//	PRD70, PRD71
	//
	if (email.length() < 1) {
		errMsg += application.getInitParameter("MSG.PRD70") + "<br>";
	}
	else {
		//	Check email format
		//
		if (!isEmailValid(email)) {
			email = "";
			errMsg += application.getInitParameter("MSG.PRD70") + "<br>";
		}
		else {
			//	Check password, only if email OK (PRD72).
			//
			if ( ( pwd.length() < 4) || ( pwd.indexOf(' ') != -1 ) ) {
				errMsg += application.getInitParameter("MSG.PRD72") + "<br>";
			}
		}
	}

	//	If all OK, try to validate user.
	//
	if (errMsg.length() == 0) {
		try {
			IAccountManager acctMgr = getAcctMgr();
			user = acctMgr.validateUser(email, pwd);
			//((IAccountManagerBean)acctMgr).remove();
			acctMgr = null;
			//	If we can validate the user, save the user & email in 
			//	the session. 
			session.setAttribute(USER_SESSID, user);
			session.setAttribute(USER_EMAIL_SESSID, email);
			//	Redirect to MyAlkindi.
			//
			response.sendRedirect(response.encodeRedirectUrl(MY_ALKINDI_PAGE));
			//	Set flag to indicate we are NOT to show the index page below.
			//
			showIndexPage = false;
		}
		catch (AlkExcept ae) {
			switch(ae.errCode()) {
				case 6502:
					errMsg += "Account suspended. Please contact Customer Service for further assistance.";
					break;
				
				case 6503:
					errMsg += "Your account was not found in our database or your password is incorrect.";
					break;
				
				default:
					throw (ae);
			}
		}
	}
	
}
else {
	//	Otherwise check for current user (if any -- null is OK here).
	//
	user = (SystemUser)session.getAttribute(USER_SESSID);
	email = "";
}
//	Do the following only if the index page is to be shown (no redirects).
//
if (showIndexPage) {
	//	If this page is displayed as a result of a refresh, use current 
	//	session's first page ratings here. If there are no ratings for
	//	this page yet, get products to rate from dB & store empty ratings
	//	at session scope.
	//
	ratingList = (RatingList)session.getAttribute(RL1_SESSID);
	if (ratingList == null) {
			IRatingManager ratMgr = getRatingMgr();
			//	Use SystemUser which has no ratings as input for getProductsToRate for 
			//	first page. 
			ProductList movieList = ratMgr.getProductsToRate(new SystemUser(1000546),8);
			//((IRatingManagerBean)ratMgr).remove();
			ratMgr = null;
			ratingList = new RatingList(null, movieList);
			session.setAttribute(RL1_SESSID, ratingList);
	}

%>
<html>
<head>
<%=releaseNum()%>
<title>Welcome To Alkindi.com</title>
<body>
<%	int ratingIdx = 0;
	int i=0;
	Iterator it = ratingList.iterator();
	while (it.hasNext()) {
		long pid = 0;
		String title = "";

		try {
			//Rating rat = ratingList.get(idx);
			Rating rat = (Rating)it.next();
			Product prod = rat.prod;
			pid = prod.id;
			
			//pid = ratingList.get(idx).prod.id;
			title = getMovieName(pid);
			i++;
		}
		catch(Exception e) {
			System.out.println("Problem in idx=" + ratingIdx);
			//throw new AlkExcept("idx=" + idx + "\nException: " + e.toString(), 8000);
			throw e;
		}
%>
<%--<a name="movie<%=ratingIdx%>"><span id="rateMovieTitle"><b><%=title%></b></span></a><br>
<input type="hidden" name="<%=PRODID_PARAM%>" value="<%=pid%>">
<input type="hidden" name="<%=RATING_PARAM%>" value="0">
--%><%		ratingIdx ++;
	}	//END Loop over Products To Rate 
%>
number of productstorate:<%=i%>
</body>
</html>
<%
}
%>
